/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime (u_Elapsed*0.1) // Slowed by TheEmu.
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

vec3 sphere = vec3(0, 0, 2);
float sphere_size = 1.3;

float hash( float n ) { return fract(sin(n)*753.5453123); }
float noise( in vec3 x )
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = f*f*(3.0-2.0*f);

    float n = p.x + p.y*157.0 + 113.0*p.z;
    return mix(mix(mix( hash(n+  0.0), hash(n+  1.0),f.x),
                   mix( hash(n+157.0), hash(n+158.0),f.x),f.y),
               mix(mix( hash(n+113.0), hash(n+114.0),f.x),
                   mix( hash(n+270.0), hash(n+271.0),f.x),f.y),f.z);
}

float raySphere(vec3 rpos, vec3 rdir, vec3 sp, float radius, inout vec3 point, inout vec3 normal) {
   radius = radius * radius;
   float dt = dot(rdir, sp - rpos);
   if (dt < 0.0) {
      return -1.0;
   }
   vec3 tmp = rpos - sp;
   tmp.x = dot(tmp, tmp);
   tmp.x = tmp.x - dt*dt;
   if (tmp.x >= radius) {
      return -1.0;
   }
   dt = dt - sqrt(radius - tmp.x);
   point = rpos + rdir * dt;
   normal = normalize(point - sp);
   return dt;
}

const mat3 m = mat3( 0.00,  0.80,  0.60,
                    -0.80,  0.36, -0.48,
                    -0.60, -0.48,  0.64 );

void main ( void )
{
   vec3 point;
   vec3 normal;
   vec2 uv = gl_FragCoord.xy / iResolution.xy * 2.0 - 1.0;
   uv.x *= iResolution.x / iResolution.y;
   uv.y = -uv.y;
   vec3 ray = vec3(uv.x, uv.y, 1.0);
   ray = normalize(ray);

   vec3 c = vec3( 0. );

   for( float i = 0.; i < 30.; i++ ) {

     float dist = raySphere(vec3(0.0), ray, sphere, sphere_size - .01 * i, point, normal);

     if (dist > 0.0) {
       float f = 0.;
       vec3 pos = 2. / ( .5 * i + 1. ) * point + .1 * iGlobalTime;
       vec3 q = 8.0*pos;
       f  = 0.5000*noise( q ); q = m*q*2.01;
       f += 0.2500*noise( q ); q = m*q*2.02;
       f += 0.1250*noise( q ); q = m*q*2.03;
       f += 0.0625*noise( q ); q = m*q*2.01;
       f *= dot( normal, vec3( 0., 0., 1. ) );
       c += vec3( f * f  );
     }
   }

   gl_FragColor.xyz = smoothstep ( 0., 1., c / 10. );
   gl_FragColor.a = length(gl_FragColor.xyz);

}